/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.block;

import java.util.HashMap;
import java.util.Map;
import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.BlockAir;
import net.jayjay.dangerzone.block.BlockBedrock;
import net.jayjay.dangerzone.block.BlockBoxOBlood;
import net.jayjay.dangerzone.block.BlockCloud;
import net.jayjay.dangerzone.block.BlockDirt;
import net.jayjay.dangerzone.block.BlockDynamite;
import net.jayjay.dangerzone.block.BlockGlass;
import net.jayjay.dangerzone.block.BlockGrass;
import net.jayjay.dangerzone.block.BlockLeaves;
import net.jayjay.dangerzone.block.BlockLog;
import net.jayjay.dangerzone.block.BlockOakSapling;
import net.jayjay.dangerzone.block.BlockPlant;
import net.jayjay.dangerzone.block.BlockSand;
import net.jayjay.dangerzone.block.BlockSpike;
import net.jayjay.dangerzone.block.BlockStone;
import net.jayjay.dangerzone.block.BlockSuperSapling;
import net.jayjay.dangerzone.block.BlockWater;

public class Blocks {
    private static final Map<String, Block> blockRegistry = new HashMap<String, Block>();
    private static final Map<String, Integer> tagToId = new HashMap<String, Integer>();
    public static int nextId = 0;
    public static int blockLimit = -1;
    public static final int maxBlocks = 4096;
    public static Block[] blocks = new Block[4096];
    public static final Block empty = null;
    public static final Block air = new BlockAir("dz2:air");
    public static final Block stone = new BlockStone("dz2:stone", "/blocks/stone.png");
    public static final Block grass = new BlockGrass("dz2:grass");
    public static final Block dirt = new BlockDirt("dz2:dirt", "/blocks/dirt.png");
    public static final Block cobbleStone = new Block("dz2:cobblestone", "/blocks/cobblestone.png");
    public static final Block oakPlanks = new Block("dz2:oak_planks", "/blocks/oak_planks.png");
    public static final Block oakSapling = new BlockOakSapling("dz2:oak_sapling", "/blocks/oak_sapling.png");
    public static final Block bedrock = new BlockBedrock("dz2:bedrock", "/blocks/bedrock.png");
    public static final Block water = new BlockWater("dz2:water", "/blocks/water.png");
    public static final Block lava = new BlockWater("dz2:lava", "/blocks/lava.png");
    public static final Block bloodBox = new BlockBoxOBlood("dz2:dork_cube");
    public static final Block bricks = new Block("dz2:bricks", "/blocks/bricks.png");
    public static final Block iron = new Block("dz2:iron_block", "/blocks/iron_block.png");
    public static final Block copper = new Block("dz2:copper_block", "/blocks/copper_block.png");
    public static final Block glass = new BlockGlass("dz2:glass", "/blocks/glass.png");
    public static final Block sand = new BlockSand("dz2:sand", "/blocks/sand.png");
    public static final Block gravel = new BlockSand("dz2:gravel", "/blocks/gravel.png");
    public static final Block stoneBrick = new Block("dz2:stone_bricks", "/blocks/stone_bricks.png");
    public static final Block oakLog = new BlockLog("dz2:oak_log", "/blocks/oak_log_top.png", "/blocks/oak_log_side.png");
    public static final Block deadSapling = new BlockPlant("dz2:dead_sapling", "/blocks/dead_sapling.png");
    public static final Block mese = new Block("dz2:mese_block", "/blocks/mese_block.png");
    public static final Block ruby = new Block("dz2:ruby_block", "/blocks/ruby_block.png");
    public static final Block blerik = new Block("dz2:blerik", "/blocks/blerik.png");
    public static final Block dynamite = new BlockDynamite("dz2:dynamite_block", "/blocks/dynamite.png", 10.0f);
    public static final Block oakLeaves = new BlockLeaves("dz2:oak_leaves", "/blocks/oak_leaves.png");
    public static final Block tallGrass = new BlockPlant("dz2:tall_grass", "/blocks/tall_grass.png");
    public static final Block rose = new BlockPlant("dz2:rose", "/blocks/rose.png");
    public static final Block cloud = new BlockCloud("dz2:cloud_block", "/blocks/cloud_block.png");
    public static final Block copperOre = new BlockStone("dz2:copper_ore", "/blocks/copper_ore.png");
    public static final Block ironOre = new BlockStone("dz2:iron_ore", "/blocks/iron_ore.png");
    public static final Block blueRose = new BlockPlant("dz2:blue_rose", "/blocks/blue_rose.png");
    public static final Block superLog = new BlockLog("dz2:super_log", "/blocks/super_log_top.png", "/blocks/super_log_side.png");
    public static final Block superLeaves = new BlockLeaves("dz2:super_leaves", "/blocks/super_leaves.png");
    public static final Block nuke = new BlockDynamite("dz2:nuke", "/blocks/nuke.png", 100.0f);
    public static final Block meseOre = new BlockStone("dz2:mese_ore", "/blocks/mese_ore.png");
    public static final Block dandelion = new BlockPlant("dz2:dandelion", "/blocks/dandelion.png");
    public static final Block rubyOre = new BlockStone("dz2:ruby_ore", "/blocks/ruby_ore.png");
    public static final Block superSapling = new BlockSuperSapling("dz2:super_sapling", "/blocks/super_sapling.png");
    public static final Block stoneSpike = new BlockSpike("dz2:stone_spike", "/blocks/stone.png");

    public static void registerBlock(Block block) {
        blockRegistry.put(block.blockTag, block);
        tagToId.put(block.blockTag, nextId);
        Blocks.blocks[Blocks.nextId] = block;
        ++nextId;
    }

    public static void registerBlock(Block block, String tag) {
        blockRegistry.put(tag, block);
        tagToId.put(tag, nextId);
        Blocks.blocks[Blocks.nextId] = block;
        ++nextId;
    }

    public static Block getBlock(String tag) {
        return blockRegistry.get(tag);
    }

    public static int getBlockID(String tag) {
        return tagToId.getOrDefault(tag, -1);
    }

    public static Block getBlockById(int id) {
        if (id >= 0 && id < blocks.length) {
            return blocks[id];
        }
        return null;
    }
}

